/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.parts.ICablePart;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.pathing.ChannelMode;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.core.definitions.AEParts;
import appeng.items.parts.ColoredPartItem;
import appeng.items.tools.powered.ColorApplicatorItem;
import appeng.parts.AEBasePart;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CablePart
extends AEBasePart
implements ICablePart {
    private static final IGridNodeListener<CablePart> NODE_LISTENER = new AEBasePart.NodeListener<CablePart>(){

        @Override
        public void onInWorldConnectionChanged(CablePart nodeOwner, IGridNode node) {
            super.onInWorldConnectionChanged(nodeOwner, node);
            nodeOwner.markForUpdate();
        }
    };
    private final int[] channelsOnSide = new int[]{0, 0, 0, 0, 0, 0};
    private Set<Direction> connections = Collections.emptySet();
    private boolean powered = false;

    public CablePart(ColoredPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(GridFlags.PREFERRED).setIdlePowerUsage(0.0).setInWorldNode(true).setExposedOnSides(EnumSet.allOf(Direction.class));
        this.getMainNode().setGridColor(partItem.getColor());
    }

    @Override
    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode(this, NODE_LISTENER);
    }

    @Override
    public BusSupport supportsBuses() {
        return BusSupport.CABLE;
    }

    @Override
    public AEColor getCableColor() {
        IPartItem<?> iPartItem = this.getPartItem();
        if (iPartItem instanceof ColoredPartItem) {
            ColoredPartItem coloredPartItem = (ColoredPartItem)iPartItem;
            return coloredPartItem.getColor();
        }
        return AEColor.TRANSPARENT;
    }

    @Override
    public AECableType getCableConnectionType() {
        return AECableType.GLASS;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        if (cable == this.getCableConnectionType()) {
            return 4.0f;
        }
        if (cable.ordinal() >= this.getCableConnectionType().ordinal()) {
            return -1.0f;
        }
        return 8.0f;
    }

    @Override
    public void onPlacement(Player player) {
        ColorApplicatorItem item;
        AEColor color;
        Item item2;
        super.onPlacement(player);
        ItemStack stack = player.m_21120_(InteractionHand.OFF_HAND);
        if (!stack.m_41619_() && (item2 = stack.m_41720_()) instanceof ColorApplicatorItem && (color = (item = (ColorApplicatorItem)item2).getActiveColor(stack)) != null && color != this.getCableColor() && item.consumeColor(stack, color, true) && this.changeColor(color, player) && !player.m_150110_().f_35937_) {
            item.consumeColor(stack, color, false);
        }
    }

    @Override
    public boolean changeColor(AEColor newColor, Player who) {
        if (this.getCableColor() != newColor) {
            IPartItem newPart = null;
            if (this.getCableConnectionType() == AECableType.GLASS) {
                newPart = AEParts.GLASS_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.COVERED) {
                newPart = AEParts.COVERED_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.SMART) {
                newPart = AEParts.SMART_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.DENSE_COVERED) {
                newPart = AEParts.COVERED_DENSE_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.DENSE_SMART) {
                newPart = AEParts.SMART_DENSE_CABLE.item(newColor);
            }
            boolean hasPermission = true;
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                hasPermission = grid.getSecurityService().hasPermission(who, SecurityPermissions.BUILD);
            }
            if (newPart != null && hasPermission) {
                if (this.isClientSide()) {
                    return true;
                }
                this.setPartItem(newPart);
                this.getMainNode().setGridColor(this.getCableColor());
                this.getHost().markForUpdate();
                this.getHost().markForSave();
                return true;
            }
        }
        return false;
    }

    @Override
    public void setExposedOnSides(EnumSet<Direction> sides) {
        this.getMainNode().setExposedOnSides(sides);
    }

    @Override
    public boolean isConnected(Direction side) {
        return this.getConnections().contains(side);
    }

    public void markForUpdate() {
        this.getHost().markForUpdate();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        this.updateConnections();
        bch.addBox(6.0, 6.0, 6.0, 10.0, 10.0, 10.0);
        IPartHost ph = this.getHost();
        if (ph != null) {
            block16: for (Direction dir : Direction.values()) {
                float dist;
                IPart p = ph.getPart(dir);
                if (p == null || (dist = p.getCableConnectionLength(this.getCableConnectionType())) > 8.0f) continue;
                switch (dir) {
                    case DOWN: {
                        bch.addBox(6.0, dist, 6.0, 10.0, 6.0, 10.0);
                        continue block16;
                    }
                    case EAST: {
                        bch.addBox(10.0, 6.0, 6.0, 16.0 - (double)dist, 10.0, 10.0);
                        continue block16;
                    }
                    case NORTH: {
                        bch.addBox(6.0, 6.0, dist, 10.0, 10.0, 6.0);
                        continue block16;
                    }
                    case SOUTH: {
                        bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0 - (double)dist);
                        continue block16;
                    }
                    case UP: {
                        bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0 - (double)dist, 10.0);
                        continue block16;
                    }
                    case WEST: {
                        bch.addBox(dist, 6.0, 6.0, 6.0, 10.0, 10.0);
                        continue block16;
                    }
                }
            }
        }
        for (Direction of : this.getConnections()) {
            switch (of) {
                case DOWN: {
                    bch.addBox(6.0, 0.0, 6.0, 10.0, 6.0, 10.0);
                    break;
                }
                case EAST: {
                    bch.addBox(10.0, 6.0, 6.0, 16.0, 10.0, 10.0);
                    break;
                }
                case NORTH: {
                    bch.addBox(6.0, 6.0, 0.0, 10.0, 10.0, 6.0);
                    break;
                }
                case SOUTH: {
                    bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0);
                    break;
                }
                case UP: {
                    bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0, 10.0);
                    break;
                }
                case WEST: {
                    bch.addBox(0.0, 6.0, 6.0, 6.0, 10.0, 10.0);
                    break;
                }
            }
        }
    }

    protected void updateConnections() {
        if (!this.isClientSide()) {
            IGridNode n = this.getGridNode();
            if (n != null) {
                this.setConnections(n.getConnectedSides());
            } else {
                this.setConnections(Collections.emptySet());
            }
        }
    }

    @Override
    public void writeToStream(FriendlyByteBuf data) {
        int flags = 0;
        boolean[] writeSide = new boolean[Direction.values().length];
        byte[] channelsPerSide = new byte[Direction.values().length];
        for (Direction thisSide : Direction.values()) {
            IPart part = this.getHost().getPart(thisSide);
            if (part == null) continue;
            writeSide[thisSide.ordinal()] = true;
            int channels = 0;
            if (part.getGridNode() != null) {
                for (IGridConnection gc : part.getGridNode().getConnections()) {
                    channels = Math.max(channels, gc.getUsedChannels());
                }
            }
            channelsPerSide[thisSide.ordinal()] = this.getVisualChannels(channels);
        }
        IGridNode n = this.getGridNode();
        if (n != null) {
            for (Map.Entry<Direction, IGridConnection> entry : n.getInWorldConnections().entrySet()) {
                int side = entry.getKey().ordinal();
                writeSide[side] = true;
                IGridConnection connection = entry.getValue();
                channelsPerSide[side] = this.getVisualChannels(connection.getUsedChannels());
                flags |= 1 << side;
            }
            if (n.isPowered()) {
                flags |= 1 << Direction.values().length;
            }
        }
        data.writeByte((int)((byte)flags));
        for (int i = 0; i < writeSide.length; ++i) {
            if (!writeSide[i]) continue;
            data.writeByte((int)channelsPerSide[i]);
        }
    }

    private byte getVisualChannels(int channels) {
        byte visualMaxChannels;
        IGridNode node = this.getGridNode();
        if (node == null) {
            return 0;
        }
        switch (this.getCableConnectionType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                byte by = 0;
                break;
            }
            case GLASS: 
            case SMART: 
            case COVERED: {
                byte by = 8;
                break;
            }
            case DENSE_COVERED: 
            case DENSE_SMART: {
                byte by = visualMaxChannels = 32;
            }
        }
        if (node.getGrid().getPathingService().getChannelMode() == ChannelMode.INFINITE) {
            return channels <= 0 ? (byte)0 : visualMaxChannels;
        }
        int gridMaxChannels = node.getMaxChannels();
        if (visualMaxChannels == 0 || gridMaxChannels == 0) {
            return 0;
        }
        byte result = (byte)Math.min(visualMaxChannels, channels * visualMaxChannels / gridMaxChannels);
        if (result == 0 && channels > 0) {
            return 1;
        }
        return result;
    }

    @Override
    public boolean readFromStream(FriendlyByteBuf data) {
        byte cs = data.readByte();
        Set<Direction> previousConnections = this.getConnections();
        boolean wasPowered = this.powered;
        boolean channelsChanged = false;
        this.powered = (cs & 1 << Direction.values().length) != 0;
        EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
        for (Direction d : Direction.values()) {
            boolean conOnSide;
            boolean bl = conOnSide = (cs & 1 << d.ordinal()) != 0;
            if (conOnSide) {
                connections.add(d);
            }
            int ch = 0;
            if (conOnSide || this.getHost().getPart(d) != null) {
                ch = data.readByte() & 0xFF;
            }
            if (ch == this.getChannelsOnSide(d.ordinal())) continue;
            channelsChanged = true;
            this.setChannelsOnSide(d.ordinal(), ch);
        }
        this.setConnections(connections);
        return !previousConnections.equals(this.getConnections()) || wasPowered != this.powered || channelsChanged;
    }

    int getChannelsOnSide(int i) {
        return this.channelsOnSide[i];
    }

    public int getChannelsOnSide(Direction side) {
        if (!this.powered) {
            return 0;
        }
        return this.channelsOnSide[side.ordinal()];
    }

    void setChannelsOnSide(int i, int channels) {
        this.channelsOnSide[i] = channels;
    }

    Set<Direction> getConnections() {
        return this.connections;
    }

    void setConnections(Set<Direction> connections) {
        this.connections = connections;
    }
}

